// GetCardsByCH.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "GetCardsByCH.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGetCardsByCH dialog


CGetCardsByCH::CGetCardsByCH(CWnd* pParent /*=NULL*/)
	: CDialog(CGetCardsByCH::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGetCardsByCH)
	//}}AFX_DATA_INIT
}
CGetCardsByCH ::CGetCardsByCH(IApplication *pApp):CDialog(CGetCardsByCH::IDD, NULL)
{
	pApplication = pApp;
	//pHwDevice.CreateInstance(__uuidof(HWDevice));
	
	
}

void CGetCardsByCH::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGetCardsByCH)
	DDX_Control(pDX, IDC_CARDLISTVIEW, m_CardListView);
	DDX_Control(pDX, IDC_CHLIST, m_CHList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAcctList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGetCardsByCH, CDialog)
	//{{AFX_MSG_MAP(CGetCardsByCH)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST, OnSelchangeSubAcctlist)
	ON_BN_CLICKED(IDC_UNASSIGNEDCARDS, OnUnassignedcards)
	ON_BN_CLICKED(IDOK, LoadAllCards)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGetCardsByCH message handlers


BOOL CGetCardsByCH::OnInitDialog() 
{
	CDialog::OnInitDialog();
	LoadAccounts();
	// TODO: Add extra initialization here
	pApplication->GetAccessLevelType(&m_nAccessType);

	m_CardListView.InsertColumn(0,_T("Card Number"),LVCFMT_LEFT,75);
	m_CardListView.InsertColumn(1,_T("Card ID"),LVCFMT_LEFT,75);
	m_CardListView.InsertColumn(2,_T("CHID"),LVCFMT_LEFT,50);
	m_CardListView.InsertColumn(3,_T("Access Level"),LVCFMT_LEFT,100);
	m_CardListView.InsertColumn(4,_T("Activation Date"),LVCFMT_LEFT,100);
	m_CardListView.InsertColumn(5,_T("Expiration Date"),LVCFMT_LEFT,100);
	m_CardListView.InsertColumn(6,_T("Card Status"),LVCFMT_LEFT,100);
	m_CardListView.InsertColumn(7,_T("NetAXS Card Type"),LVCFMT_LEFT,100);
	m_CardListView.InsertColumn(8,_T("NetAXS Usage Limit"),LVCFMT_LEFT,100);
	// added for the Better Object Display -- Guru
	m_CardListView.InsertColumn(9,_T("PIN"),LVCFMT_LEFT,100);
	m_CardListView.InsertColumn(10,_T("Issue Code"),LVCFMT_LEFT,100);
	
	m_CardListView.ShowScrollBar(SB_BOTH);
	m_CardListView.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
void CGetCardsByCH :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				m_AcctList.SetItemData(m_AcctList.AddString(pAccount->AccountName),pAccount->AccountID);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
}

void CGetCardsByCH :: LoadSubAccounts()
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
				
		//select AccountID
		int index_Acct = m_AcctList.GetCurSel();		
		long lAccountID = m_AcctList.GetItemData(index_Acct);	

		if(lAccountID <= 0)
		{
			AfxMessageBox(L"Select Account!");
			return;
		}
		pApplication->GetSubAccountsByAccountID(lAccountID, &vSubAccounts); // get account details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0, lBound ;
		IAccount *pSubAccount= NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		sa.GetLBound(1,&lBound);
		UpdateData(TRUE);
		for(long i =lBound ;i <= uBound ; i++)		
		{			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount!= NULL)
			{				
				m_SubAcctList.SetItemData(m_SubAcctList.AddString(pSubAccount->AccountName), pSubAccount->AccountID);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	
	//m_AccountList.SetCurSel(0);
	
}

void CGetCardsByCH ::LoadCardHolders()
{
	
	m_CHList.ResetContent();

		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		BSTR bstrAcctName2 = sAcctName.AllocSysString();

		//select sub account name 
		int indexSub = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		// WPACT-5808 : Kalpesh
		if(indexSub > 0)
			m_SubAcctList.GetLBText(indexSub,sSubAcctName);
		BSTR bstrSubAcctName2 = sSubAcctName.AllocSysString();

		_variant_t vCHs;
		vCHs.Clear();
		pApplication->GetCardHoldersByAccountName(bstrAcctName2, bstrSubAcctName2,&vCHs); // get card holder details of particular account  in WP-CS database server
		
		if(vCHs.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ICardHolder *pCH = NULL;
		
		COleSafeArray sa(vCHs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ICardHolder,(void**)&pCH);
			if (pCH != NULL)
			{
				CString sCHid;
				sCHid.Format(L"%ld",pCH->CardHolderID);
				m_CHList.SetItemData(m_CHList.AddString(sCHid),pCH->CardHolderID);
				pCH->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_CHList.SetCurSel(0);
}

void CGetCardsByCH::OnSelchangeAcctlist() 
{
	m_CHList.ResetContent();
	m_CardListView.DeleteAllItems();
	m_SubAcctList.ResetContent();

	LoadSubAccounts();
	
	LoadCardHolders();
	LoadAllCards();
	
}


void CGetCardsByCH::OnSelchangeSubAcctlist() 
{
	//m_CHList.ResetContent();
	//m_CardListView.DeleteAllItems();
	LoadCardHolders();
	//LoadAllCards();
	
	
	
}

/*
void CGetCardsByCH::OnOK() 
{
		//m_CardsList.ResetContent();
		m_CardListView.DeleteAllItems();//Bharani Jun-25-08
		_variant_t vCards;
		vCards.Clear();

		//select CHID0
		long lCardHolderID;
		int index_CH = m_CHList.GetCurSel();
		if (index_CH < 0)
		{
			lCardHolderID = 0;
		}
		else
		{
			CString sCHid;
			m_CHList.GetLBText(index_CH,sCHid);
			lCardHolderID = atoi(sCHid);
		}
		
		// get Card details in WP-CS database server by specified cardholder
		pApplication->GetCardsByCHID(lCardHolderID,&vCards); 
		
		if(vCards.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ICard *pCard = NULL;
		
		COleSafeArray sa(vCards);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ICard,(void**)&pCard);
			if (pCard != NULL)
			{
				//m_CardsList.AddString(pCard->CardNumber);
				int nListViewCounter=m_CardListView.GetItemCount();
				m_CardListView.InsertItem(nListViewCounter,pCard->CardNumber);
				// Get Card ID
				CString szCardID;
				szCardID.Format("%ld",pCard->CardID);
				m_CardListView.SetItemText(nListViewCounter,1,szCardID);
				// get CHID
				CString szCHID;
				szCHID.Format("%ld",pCard->CardHolderID);
				m_CardListView.SetItemText(nListViewCounter,2,szCHID);
				if(m_nAccessType == 0 )//Precision mode	
				{
						m_CardListView.SetItemText(nListViewCounter,3,pCard->AccessLevelName);
				}
				else if(m_nAccessType == 1)//Multiple mode
				{
					//TODO: Handle multiple access levels
					_variant_t vAccls;
					vAccls.Clear();
					vAccls = pCard->AccessLevels;
					if( VT_EMPTY != vAccls.vt)//There is one or more access
											  //level associated
					{
						long lAcclsUBound=0;
						COleSafeArray saAccls(vAccls);
						saAccls.GetUBound(1,&lAcclsUBound);
						CString szListContent;						
						for(long lCounter = 0; lCounter <= lAcclsUBound; lCounter++)
						{
							BSTR bstrTmpContainer;
							saAccls.GetElement(&lCounter,(void*)&bstrTmpContainer);
							CString szTmpContainer(bstrTmpContainer);
							SysFreeString(bstrTmpContainer);
							szListContent+=szTmpContainer;
							if( lCounter != lAcclsUBound )
								szListContent+=" | ";
						}
						//CString szTmp;
						//szTmp.Format("%ld",lAcclsUBound);
						//m_CardListView.SetItemText(nListViewCounter,2,szTmp);
						m_CardListView.SetItemText(nListViewCounter,3,szListContent);																		
					}					
				}

				m_CardListView.SetItemText(nListViewCounter,4,pCard->ActivationDate);
				m_CardListView.SetItemText(nListViewCounter,5,pCard->ExpirationDate);
				CString szCardStatus;
				szCardStatus.Format("%ld",pCard->CardStatus);
				m_CardListView.SetItemText(nListViewCounter,6,szCardStatus);

				//NetAXS Card Update -- Guru
				int iCardType	= pCard->NetAXSCardType;
				BOOL bLimited	= pCard->NetAXSLimitedCard;
				BOOL bTemp		= pCard->NetAXSTempCard;
				int nLimits		= pCard->NetAXSUsageLimit;

				CString sNXCardType;
				switch(iCardType)
				{
					case 0:
						sNXCardType = _T("Standard");
						break;

					case 1:
						sNXCardType = _T("Supervisor");
						break;

					case 2:
						sNXCardType = _T("VIP");
						break;

				}

				sNXCardType += bLimited?_T(" Limited Usage"):_T("");
				sNXCardType += bTemp?_T(" Temperory"):_T("");

				m_CardListView.SetItemText(nListViewCounter,7,sNXCardType);

				CString sLimit;
				sLimit.Format(_T("%d"),nLimits);
				m_CardListView.SetItemText(nListViewCounter,8,sLimit);

				
				m_CardListView.SetItemText(nListViewCounter,9,pCard->PIN1);

				CString sIssueCode;
				sIssueCode.Format("%ld", pCard->Issue);
				m_CardListView.SetItemText(nListViewCounter,10,sIssueCode);

				pCard->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	

}*/
// Modified by viswa jul-30-2008 for getting cards without CHID
void CGetCardsByCH::OnUnassignedcards() 
{
		m_CardListView.DeleteAllItems();
		_variant_t vCardsUnasssigned;
		vCardsUnasssigned.Clear();
	
		
		//select AccountID
		int index_Acct = m_AcctList.GetCurSel();		
		long lAccountID = m_AcctList.GetItemData(index_Acct);

		//select SUB AccountID
		int index_SubAcct = m_SubAcctList.GetCurSel();		
		long lSubAccountID = m_SubAcctList.GetItemData(index_SubAcct);

		pApplication->GetCardsWithoutCHIDByAcctID(lAccountID, lSubAccountID, &vCardsUnasssigned); 
		
		if(vCardsUnasssigned.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ICard *pCard = NULL;
		
		COleSafeArray sa(vCardsUnasssigned);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ICard,(void**)&pCard);
			if (pCard != NULL)
			{
				//m_CardsList.AddString(pCard->CardNumber);
				int nListViewCounter=m_CardListView.GetItemCount();
				m_CardListView.InsertItem(nListViewCounter,pCard->CardNumber);
				//Expose the CardID
				CString szCardID;
				szCardID.Format(L"%ld",pCard->CardID);
				m_CardListView.SetItemText(nListViewCounter,1,szCardID);
				//Expose the CardHolderID
				CString szCHID;
				szCHID.Format(L"%ld",pCard->CardHolderID);
				m_CardListView.SetItemText(nListViewCounter,2,szCHID);

				if(m_nAccessType == 0 )//Precision mode	
				{
						m_CardListView.SetItemText(nListViewCounter,3,pCard->AccessLevelName);
				}
				else if(m_nAccessType == 1)//Multiple mode
				{
					//TODO: Handle multiple access levels
					_variant_t vAccls;
					vAccls.Clear();
					vAccls = pCard->AccessLevels;
					if( VT_EMPTY != vAccls.vt)//There is one or more access
											  //level associated
					{
						long lAcclsUBound=0;
						COleSafeArray saAccls(vAccls);
						saAccls.GetUBound(1,&lAcclsUBound);
						CString szListContent;						
						for(long lCounter = 0; lCounter <= lAcclsUBound; lCounter++)
						{
							BSTR bstrTmpContainer;
							saAccls.GetElement(&lCounter,(void*)&bstrTmpContainer);
							CString szTmpContainer(bstrTmpContainer);
							SysFreeString(bstrTmpContainer);
							szListContent+=szTmpContainer;
							if( lCounter != lAcclsUBound )
								szListContent+=" | ";
						}
						//CString szTmp;
						//szTmp.Format("%ld",lAcclsUBound);
						//m_CardListView.SetItemText(nListViewCounter,2,szTmp);
						m_CardListView.SetItemText(nListViewCounter,3,szListContent);																		
					}					
				}

				m_CardListView.SetItemText(nListViewCounter,4,pCard->ActivationDate);
				m_CardListView.SetItemText(nListViewCounter,5,pCard->ExpirationDate);
				CString szCardStatus;
				szCardStatus.Format(L"%ld",pCard->CardStatus);
				m_CardListView.SetItemText(nListViewCounter,6,szCardStatus);

				//NetAXS Card Update -- Guru
				int iCardType	= pCard->NetAXSCardType;
				BOOL bLimited	= pCard->NetAXSLimitedCard;
				BOOL bTemp		= pCard->NetAXSTempCard;
				int nLimits		= pCard->NetAXSUsageLimit;

				CString sNXCardType;
				switch(iCardType)
				{
					case 0:
						sNXCardType = _T("Standard");
						break;

					case 1:
						sNXCardType = _T("Supervisor");
						break;

					case 2:
						sNXCardType = _T("VIP");
						break;

				}

				sNXCardType += bLimited?_T(" Limited Usage"):_T("");
				sNXCardType += bTemp?_T(" Temperory"):_T("");

				m_CardListView.SetItemText(nListViewCounter,7,sNXCardType);

				CString sLimit;
				sLimit.Format(_T("%d"),nLimits);
				m_CardListView.SetItemText(nListViewCounter,8,sLimit);

				m_CardListView.SetItemText(nListViewCounter,9,pCard->PIN1);

				CString sIssueCode;
				sIssueCode.Format(L"%ld", pCard->Issue);
				m_CardListView.SetItemText(nListViewCounter,10,sIssueCode);

				pCard->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	// TODO: Add your control notification handler code here

}


void CGetCardsByCH::LoadAllCards()
{

	m_CardListView.DeleteAllItems();//Bharani Jun-25-08
	_variant_t vCards;
	vCards.Clear();

	BSTR bstrAcctName;
	//select account name 
	int index_Account = m_AcctList.GetCurSel();
	CString sAcctName;
	if (index_Account <0)
		bstrAcctName = SysAllocString(L"");
	else
	{
		m_AcctList.GetLBText(index_Account,sAcctName);
		bstrAcctName = sAcctName.AllocSysString();
	}

	//select Sub account name 
	BSTR bstrSubAcctName;
	int index_SubAccount = m_SubAcctList.GetCurSel();
	CString sSubAcctName;
	if (index_SubAccount <0)
		bstrSubAcctName = SysAllocString(L"");
	else
	{
		m_SubAcctList.GetLBText(index_SubAccount,sSubAcctName);
		bstrSubAcctName = sSubAcctName.AllocSysString();
	}
	
	// get Card details in WP-CS database server by specified cardholder
	pApplication->GetCardsByCHID(m_CHList.GetItemData(m_CHList.GetCurSel()), &vCards);
	
	if(vCards.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	ICard *pCard = NULL;
	
	COleSafeArray sa(vCards);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)			
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_ICard,(void**)&pCard);
		if (pCard != NULL)
		{
			//m_CardsList.AddString(pCard->CardNumber);
			int nListViewCounter=m_CardListView.GetItemCount();
			m_CardListView.InsertItem(nListViewCounter,pCard->CardNumber);
			// Get Card ID
			CString szCardID;
			szCardID.Format(L"%ld",pCard->CardID);
			m_CardListView.SetItemText(nListViewCounter,1,szCardID);
			// get CHID
			CString szCHID;
			szCHID.Format(L"%ld",pCard->CardHolderID);
			m_CardListView.SetItemText(nListViewCounter,2,szCHID);
			if(m_nAccessType == 0 )//Precision mode	
			{
					m_CardListView.SetItemText(nListViewCounter,3,pCard->AccessLevelName);
			}
			else if(m_nAccessType == 1)//Multiple mode
			{
				//TODO: Handle multiple access levels
				_variant_t vAccls;
				vAccls.Clear();
				vAccls = pCard->AccessLevels;
				if( VT_EMPTY != vAccls.vt)//There is one or more access
										  //level associated
				{
					long lAcclsUBound=0;
					COleSafeArray saAccls(vAccls);
					saAccls.GetUBound(1,&lAcclsUBound);
					CString szListContent;						
					for(long lCounter = 0; lCounter <= lAcclsUBound; lCounter++)
					{
						BSTR bstrTmpContainer;
						saAccls.GetElement(&lCounter,(void*)&bstrTmpContainer);
						CString szTmpContainer(bstrTmpContainer);
						SysFreeString(bstrTmpContainer);
						szListContent+=szTmpContainer;
						if( lCounter != lAcclsUBound )
							szListContent+=" | ";
					}
					//CString szTmp;
					//szTmp.Format("%ld",lAcclsUBound);
					//m_CardListView.SetItemText(nListViewCounter,2,szTmp);
					m_CardListView.SetItemText(nListViewCounter,3,szListContent);																		
				}					
			}

			m_CardListView.SetItemText(nListViewCounter,4,pCard->ActivationDate);
			m_CardListView.SetItemText(nListViewCounter,5,pCard->ExpirationDate);
			CString szCardStatus;
			szCardStatus.Format(L"%ld",pCard->CardStatus);
			m_CardListView.SetItemText(nListViewCounter,6,szCardStatus);

			//NetAXS Card Update -- Guru
			int iCardType	= pCard->NetAXSCardType;
			BOOL bLimited	= pCard->NetAXSLimitedCard;
			BOOL bTemp		= pCard->NetAXSTempCard;
			int nLimits		= pCard->NetAXSUsageLimit;

			CString sNXCardType;
			switch(iCardType)
			{
				case 0:
					sNXCardType = _T("Standard");
					break;

				case 1:
					sNXCardType = _T("Supervisor");
					break;

				case 2:
					sNXCardType = _T("VIP");
					break;

			}

			sNXCardType += bLimited?_T(" Limited Usage"):_T("");
			sNXCardType += bTemp?_T(" Temperory"):_T("");

			m_CardListView.SetItemText(nListViewCounter,7,sNXCardType);

			CString sLimit;
			sLimit.Format(_T("%d"),nLimits);
			m_CardListView.SetItemText(nListViewCounter,8,sLimit);

			m_CardListView.SetItemText(nListViewCounter,9,pCard->PIN1);

			CString sIssueCode;
			sIssueCode.Format(L"%ld", pCard->Issue);
			m_CardListView.SetItemText(nListViewCounter,10,sIssueCode);
			
			pCard->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}

